#include <ctype.h>
#include "cpmio.h"


static
clean(char str[], int len)
{
	str[len] = '\0';
	while (len-- > 0) {
		if (!(isspace(str[len])) && !(iscntrl(str[len]))) break;
		str[len] = ' ';
	}
	while (len >= 0) {
		str[len] = islower(str[len]) ? toupper(str[len]):str[len] ;
		len--;
	}
}

/*
 * Separate fname into name and extension, return FALSE if
 * bad file name, otherwise TRUE.
 */

cpm_namesep(fname, name, ext)
	char fname[], name[], ext[];
{

	int i = 0;

	strncpy(name, "         ", 9);
	strncpy(ext, "    ", 4);
	while(i<8 && !(iscntrl(fname[i])) && fname[i] != '.') {
		name[i] = fname[i];
		i++;
	}

	clean(name, 8);
	if (fname[i] == '.') {
		strncpy(ext, fname+i+1, 3);
		clean(ext, 3);
	} else {
		if (fname[i] != ' ' && fname[i] != '\0') {
		    return(FALSE);
		}
	}

	if (!(isalnum(name[0]))) {
		return(FALSE);
	}
	return(TRUE);
}
